from datetime import timedelta
import time


class TimeCounter:
    def __init__(self, msg=''):
        self.start = 0
        self.finish = 0
        self.msg = msg

    def __enter__(self):
        self.start = time.time()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.finish = time.time()
        elapsed = timedelta(seconds=self.finish - self.start)
        t1, t2 = str(elapsed).split('.')
        print(f'{self.msg} {t1}.{t2[:2]}')
